﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Runtime.InteropServices;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static TJ_SangeElec.PCIE_CAN;

namespace PCIE_CAN
{
    public partial class Sub_form : Form
    {
        public int DevTpye = -1;
        public int DevIndex = -1;
        public bool FilterEnableCan0 = false;
        public bool FilterEnableCan1 = false;
        public struct channel_t
        {
            public byte Enable;
            public byte FDFlag;
            public byte NON_ISO;
            public byte Mode;
            public byte Timing0;
            public byte Timing1;
            public byte nc0;
            public byte nc1;
        }
        public struct can_t
        {
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 2)]
            public channel_t[] ch;
        }
        public struct VCI_FILTER_CONFIG
        {
            public int type;
            public UInt16 sMin;
            public UInt16 sMax;
            public UInt32 eMin;
            public UInt32 eMax;

        }

        public struct filter_t
        {
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 2)]
            public VCI_FILTER_CONFIG[] ch;
        }
        public can_t can = new can_t();
        public filter_t filter = new filter_t();

        

        public Sub_form()
        {
            InitializeComponent();

            comboBox1.SelectedIndex = 0;
            comboBox2.SelectedIndex = 0;
            comboBox3.SelectedIndex = 10;
            comboBox4.SelectedIndex = 10;
            comboBox5.SelectedIndex = 0;
            comboBox6.SelectedIndex = 0;
            comboBox7.SelectedIndex = 10;
            comboBox8.SelectedIndex = 10;
            comboBox9.SelectedIndex = 0;
            comboBox10.SelectedIndex = 0;
            comboBox11.SelectedIndex = 2;
            comboBox12.SelectedIndex = 2;


            filter.ch = new VCI_FILTER_CONFIG[2];

        }

        private void button2_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel; Close();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            byte[] Timing = { 0xB0, 0xA0, 0x90, 0x80, 0x70, 0x60, 0x50, 0x40, 0x30, 0x20, 0x10 };
            DevTpye = (int)comboBox9.SelectedIndex;
            DevIndex = (int)comboBox10.SelectedIndex;
            can.ch = new channel_t[2];
            can.ch[0].Enable = (byte)(checkBox1.Checked == true ? 1 : 0);
            can.ch[0].FDFlag = (byte)comboBox1.SelectedIndex;
            can.ch[0].Mode = (byte)comboBox2.SelectedIndex;
            can.ch[0].NON_ISO = (byte)(checkBox3.Checked == true ? 1 : 0);
            can.ch[0].Timing0 = Timing[comboBox3.SelectedIndex];
            can.ch[0].Timing1 = Timing[comboBox4.SelectedIndex];
            can.ch[1].Enable = (byte)(checkBox2.Checked == true ? 1 : 0);
            can.ch[1].FDFlag = (byte)comboBox5.SelectedIndex;
            can.ch[1].Mode = (byte)comboBox6.SelectedIndex;
            can.ch[1].NON_ISO = (byte)(checkBox4.Checked == true ? 1 : 0);
            can.ch[1].Timing0 = Timing[comboBox7.SelectedIndex];
            can.ch[1].Timing1 = Timing[comboBox8.SelectedIndex];

            filter.ch[0].type = comboBox11.SelectedIndex + 1;
            filter.ch[0].sMin = (UInt16)Convert.ToUInt16(textBox1.Text, 16);
            filter.ch[0].sMax = (UInt16)Convert.ToUInt16(textBox2.Text, 16);
            filter.ch[0].eMin = (UInt32)Convert.ToUInt32(textBox4.Text, 16);
            filter.ch[0].eMax = (UInt32)Convert.ToUInt32(textBox3.Text, 16);

            filter.ch[1].type = comboBox12.SelectedIndex + 1;
            filter.ch[1].sMin = (UInt16)Convert.ToUInt16(textBox5.Text, 16);
            filter.ch[1].sMax = (UInt16)Convert.ToUInt16(textBox6.Text, 16);
            filter.ch[1].eMin = (UInt32)Convert.ToUInt32(textBox7.Text, 16);
            filter.ch[1].eMax = (UInt32)Convert.ToUInt32(textBox8.Text, 16);

            DialogResult = DialogResult.OK;
            Close();

        }

        private void comboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBox1.SelectedIndex == 0)
            {
                label4.Visible = false;
                label13.Visible = false;
                comboBox4.Visible = false;
                checkBox3.Enabled = false;
            }
            else
            {
                label4.Visible = true;
                label13.Visible = true;
                comboBox4.Visible = true;
                checkBox3.Enabled = true;
            }
        }

        private void comboBox5_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (comboBox5.SelectedIndex == 0)
            {
                label8.Visible = false;
                label14.Visible = false;
                comboBox8.Visible = false;
                checkBox4.Enabled = false;
            }
            else
            {
                label8.Visible = true;
                label14.Visible = true;
                comboBox8.Visible = true;
                checkBox4.Enabled = true;
            }
        }







    }
}
