﻿/*
 * 由SharpDevelop创建。
 * 用户： SG--WMH
 * 日期: 2022/4/12
 * 时间: 11:13
 * 
 * 要改变这种模板请点击 工具|选项|代码编写|编辑标准头文件
 */
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;
using System.Threading;
using System.Runtime.InteropServices;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;
using System.Runtime.Serialization;

namespace TJ_SangeElec
{
	/// <summary>
	/// Description of MainForm.
	/// </summary>
	public partial class MainForm : Form
	{
		public MainForm()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			//
			// TODO: Add constructor code after the InitializeComponent() call.
			//
			
			comboBox_Device.SelectedIndex = 0;

            PCIE_CAN form = new PCIE_CAN();
			form.Owner = this;
			this.Hide();
			form.ShowDialog();
			Application.ExitThread();
			System.Environment.Exit(0);
		}

	}
	public class MyTool  //工具类
	{
		public static void delay_ms(int ms)
		{
			DateTime now = DateTime.Now;
			int count = 0;
			do {
				TimeSpan span = DateTime.Now - now;
				count = span.Seconds * 1000 + span.Milliseconds;
			} while(count <= ms);
		}
		
		public static uint HexStringToUint(string hexSting)
		{
			uint tempUint = 0;
			char[] tempChar = hexSting.ToCharArray();
			for(byte i = 0; i < tempChar.Length; i++)
			{
				if(tempChar[i] >= '0' && tempChar[i] <= '9')
				{
					tempUint = tempUint * 16 + (uint)(tempChar[i] - '0');
				}
				else if(tempChar[i] >= 'A' && tempChar[i] <= 'F')
				{
					tempUint = tempUint * 16 + (uint)(tempChar[i] - 'A') + 10;
				}
				else if(tempChar[i] >= 'a' && tempChar[i] <= 'f')
				{
					tempUint = tempUint * 16 + (uint)(tempChar[i] - 'a') + 10;
				}
			}
			return tempUint;
		}
		public static ulong HexStringToUlong(string hexSting)
		{
			ulong tempUlong = 0;
			char[] tempChar = hexSting.ToCharArray();
			for(byte i = 0; i < tempChar.Length; i++)
			{
				if(tempChar[i] >= '0' && tempChar[i] <= '9')
				{
					tempUlong = tempUlong * 16 + (ulong)(tempChar[i] - '0');
				}
				else if(tempChar[i] >= 'A' && tempChar[i] <= 'F')
				{
					tempUlong = tempUlong * 16 + (ulong)(tempChar[i] - 'A') + 10;
				}
			}
			return tempUlong;
		}
		
		public static String transMacToString(byte[] buf, int off)
		{
			String mac0 = buf[off + 0].ToString("X2");
			String mac1 = buf[off + 1].ToString("X2");
			String mac2 = buf[off + 2].ToString("X2");
			String mac3 = buf[off + 3].ToString("X2");
			String mac4 = buf[off + 4].ToString("X2");
			String mac5 = buf[off + 5].ToString("X2");
			String ret = mac0 + ":" + mac1 + ":" + mac2 + ":" + mac3 + ":" + mac4 + ":" + mac5;
			return ret;
		}
		public static String transIpToString(byte[] buf, int off)
		{
			String ip0 = buf[off + 0].ToString();
			String ip1 = buf[off + 1].ToString();
			String ip2 = buf[off + 2].ToString();
			String ip3 = buf[off + 3].ToString();
			String ret = ip0 + "." + ip1 + "." + ip2 + "." + ip3;
			return ret;
		}
		
		public static void getMacFromString(byte[] buf, int off, String str)
		{
		    char[] separator = new char[] { ':' };
		    string[] temp = str.Split(separator);
		    if(temp.Length != 6)
		    {
		    	return;
		    }
		    buf[off + 0] = (byte)MyTool.HexStringToUint(temp[0]);
		    buf[off + 1] = (byte)MyTool.HexStringToUint(temp[1]);
		    buf[off + 2] = (byte)MyTool.HexStringToUint(temp[2]);
		    buf[off + 3] = (byte)MyTool.HexStringToUint(temp[3]);
		    buf[off + 4] = (byte)MyTool.HexStringToUint(temp[4]);
		    buf[off + 5] = (byte)MyTool.HexStringToUint(temp[5]);
		}
		public static void getIpFromString(byte[] buf, int off, String str)
		{
		    char[] separator = new char[] { '.' };
		    string[] temp = str.Split(separator);
		    if(temp.Length != 4)
		    {
		    	return;
		    }
		    buf[off + 0] = Convert.ToByte(temp[0]);
		    buf[off + 1] = Convert.ToByte(temp[1]);
		    buf[off + 2] = Convert.ToByte(temp[2]);
		    buf[off + 3] = Convert.ToByte(temp[3]);
		}
		
		public static int hexStringToBytes(string s, byte[] array, int offset)
		{
			int sLen = s.Length;
			for(int i = 0; i < sLen / 2; i++)
			{
			    string abyte = s.Substring(2 * i, 2);
			    array[offset + i] = Convert.ToByte(abyte, 16);
			}
			return sLen / 2;
		}
		public static ushort modbusCrc(int len, byte[] pDataBytes)
        {
            ushort crc = 0xffff;
            ushort polynom = 0xA001;
 
            for (int i = 0; i < len; i++)
            {
                crc ^= pDataBytes[i];
                for (int j = 0; j < 8; j++)
                {
                    if ((crc & 0x01) == 0x01)
                    {
                        crc >>= 1;
                        crc ^= polynom;
                    }
                    else
                    {
                        crc >>= 1;
                    }
                }
            }
 
            ushort tmp = crc;  //高低位调换
            crc = (ushort)((tmp & 0xFF) << 8);
            crc |= (ushort)((tmp >> 8) & 0xFF);
            
            return crc;
        }
		
		public static byte[] structToByteArray(object structt)
		{
			int size = Marshal.SizeOf(structt);
			
			byte[] bytes = new byte[size];
			
			IntPtr structPtr = Marshal.AllocHGlobal(size);
			
			Marshal.StructureToPtr(structt, structPtr, false);
			
			Marshal.Copy(structPtr, bytes, 0, size);
			
			Marshal.FreeHGlobal(structPtr);
			
			return bytes;
		}
		
		public static object byteArrayToStruct(byte[] bytes, int offset, Type type)
		{
			int size = Marshal.SizeOf(type);
			
			if(size > bytes.Length - offset)
			{
				MessageBox.Show("byteArrayToStruct()", "ERROR");
				return null;
			}
			
			IntPtr structPtr = Marshal.AllocHGlobal(size);
			
			Marshal.Copy(bytes, offset, structPtr, size);
			
			object obj = Marshal.PtrToStructure(structPtr, type);
			
			Marshal.FreeHGlobal(structPtr);
			
			return obj;
		}
		
		// Convert an object to a byte array
		public static byte[] ObjectToByteArray(Object obj)
		{
		    BinaryFormatter bf = new BinaryFormatter();
		    using (var ms = new MemoryStream())
		    {
		        bf.Serialize(ms, obj);
		        return ms.ToArray();
		    }
		}
		
		// Convert a byte array to an Object
		public static object ByteArrayToObject(byte[] arrBytes)
		{
		    using (var memStream = new MemoryStream())
		    {
		        var binForm = new BinaryFormatter();
		        memStream.Write(arrBytes, 0, arrBytes.Length);
		        memStream.Seek(0, SeekOrigin.Begin);
		        var obj = binForm.Deserialize(memStream);
		        return obj;
		    }
		}
		
		// Convert a byte array to an Object
		public static object ByteArrayToObject(byte[] bytes, int offset, int len)
		{
		    using (var memStream = new MemoryStream())
		    {
		        var binForm = new BinaryFormatter();
		        memStream.Write(bytes, offset, len);
		        memStream.Seek(0, SeekOrigin.Begin);
		        var obj = binForm.Deserialize(memStream);
		        return obj;
		    }
		}
		
		public static T DeepClone<T>(T obj)
	    {
	        using (MemoryStream memoryStream = new MemoryStream())
	        {
	            IFormatter formatter = new BinaryFormatter();
	            formatter.Serialize(memoryStream, obj);
	            memoryStream.Seek(0, SeekOrigin.Begin);
	            return (T)formatter.Deserialize(memoryStream);
	        }
	    }
	}
}
